implementation module windowdraw


//	Clean Object I/O library, version 1.0.1

//	Drawing operations on windows.

import	StdInt
import	ospicture, oswindow
import	windowhandle


/*	drawwindowlook wPtr window
		applies the Look function of window.
	The wPtr argument must be the OSWindowPtr of window.
	It is assumed that window refers to a Window with a valid ClipState.
*/
drawwindowlook :: !OSWindowPtr !(WindowHandle .ls .ps) !*OSToolbox -> (!WindowHandle .ls .ps,!*OSToolbox)
drawwindowlook wPtr wH=:{whSelect,whSize,whWindowInfo=Just info=:{windowDomain,windowOrigin,windowLook,windowClip}} tb
	# (osPict,tb)		= OSgrabWindowPictContext wPtr tb
	# picture			= packPicture windowOrigin windowLook.lookPen osPict tb
	# (_,picture)		= pictsetcliprgn windowClip.clipRgn picture
	# picture			= StrictSeq (windowLook.lookFun select updState) picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseWindowPictContext wPtr osPict tb
	= ({wH & whWindowInfo=Just {info & windowLook={windowLook & lookPen=pen}}},tb)
where
	select				= if whSelect Able Unable
	wFrame				= {	corner1 = windowOrigin
						  ,	corner2 = {	x = min (windowOrigin.x+whSize.w) windowDomain.corner2.x
						  			  ,	y = min (windowOrigin.y+whSize.h) windowDomain.corner2.y
						  			  }
						  }
	updState			= RectangleToUpdateState wFrame

/*	drawinwindow wPtr drawFs window
		applies the list of drawing functions to the window.
	The wPtr argument must be the OSWindowPtr of the window.
	It is assumed that window refers to a Window with a valid ClipState.
*/
drawinwindow :: !OSWindowPtr ![DrawFunction] !(WindowHandle .ls .ps) !*OSToolbox -> (!WindowHandle .ls .ps,!*OSToolbox)
drawinwindow wPtr drawfs wH=:{whSize,whWindowInfo=Just info=:{windowOrigin,windowLook,windowClip}} tb
	# (osPict,tb)		= OSgrabWindowPictContext wPtr tb
	# picture			= packPicture windowOrigin windowLook.lookPen osPict tb
	# (_,picture)		= pictsetcliprgn windowClip.clipRgn picture
	# picture			= StrictSeq drawfs picture
	# (_,pen,osPict,tb)	= unpackPicture picture
	# tb				= OSreleaseWindowPictContext wPtr osPict tb
	= ({wH & whWindowInfo=Just {info & windowLook={windowLook & lookPen=pen}}},tb)
